<!DOCTYPE html>
<html lang="<?php echo e($lang ?? 'en'); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>SLT MOBITEL Registration</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            background: linear-gradient(90deg, #00C800 0%, #00C8FF 50%, #0025FF 100%) !important;
            background-repeat: no-repeat;
            margin: 0;
            height: 100%;
        }

        .card {
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(5px);
            border-radius: 15px;
            padding: 2rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        .input-field {
            border-radius: 10px;
            border: 1px solid #256EAF;
            padding: 0.75rem;
            width: 100%;
            transition: border-color 0.3s;
        }

        .input-field:focus {
            border-color: #50B748;
            outline: none;
        }

        .btn-register {
            background: linear-gradient(90deg, #00C800 0%, #00C8FF 50%, #0025FF 100%) !important;
            border-radius: 10px;
            padding: 0.75rem;
            color: white;
            width: 100%;
            transition: opacity 0.3s;
        }

        .btn-register:hover {
            opacity: 0.9;
        }

        .loader {
            border-top-color: #50B748;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }
    </style>
</head>

<body class="flex items-center justify-center min-h-screen px-4">
    <div class="card w-full max-w-md my-5">
        <!-- Loader -->
        <div id="loader" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden"
            aria-hidden="true">
            <div class="loader ease-linear rounded-full border-8 border-t-8 border-white h-16 w-16"
                aria-label="Loading"></div>
        </div>
        <form method="POST" action="<?php echo e(route('register.store')); ?>" class="my-2">
            <?php echo csrf_field(); ?>
            <input type="text" hidden name="language" value="<?php echo e($lang ?? 'en'); ?>">
            <img src="<?php echo e(asset('/assets/SLTMobitel_Logo.png')); ?>" alt="SLT MOBITEL Logo" class="mx-auto mb-4 w-1/2" />
            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700" for="name">
                        <?php if($lang == 'si'): ?>
                            නම
                        <?php elseif($lang == 'ta'): ?>
                            பெயர்
                        <?php else: ?>
                            Name
                        <?php endif; ?>
                        <span class="text-red-500">*</span>
                    </label>
                    <input type="text" name="name" id="name" class="input-field" value="<?php echo e(old('name')); ?>"
                        placeholder="<?php if($lang == 'si'): ?> ඔබගේ නම ඇතුලත් කරන්න <?php elseif($lang == 'ta'): ?> பெயரை உள்ளிடவும் <?php else: ?> Enter Your Name <?php endif; ?>">
                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-sm text-red-500 mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700" for="contact">
                        <?php if($lang == 'si'): ?>
                            දුරකථන අංකය
                        <?php elseif($lang == 'ta'): ?>
                            தொலைபேசி எண்
                        <?php else: ?>
                            Contact Number
                        <?php endif; ?> <span class="text-red-500">*</span>
                    </label>
                    <input type="tel" name="contact" id="contact" class="input-field" value="<?php echo e(old('contact')); ?>"
                        pattern="[0-9]{10}"
                        placeholder="<?php if($lang == 'si'): ?> ඔබගේ දුරකථන අංකය ඇතුලත් කරන්න <?php elseif($lang == 'ta'): ?> தொலைபேசி எண்ணை உள்ளிடவும் <?php else: ?> Enter Your Contact Number <?php endif; ?>">
                    <?php $__errorArgs = ['contact'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-sm text-red-500 mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700" for="gender">
                        <?php if($lang == 'si'): ?>
                            ස්ත්‍රී/පුරුෂ භාවය
                        <?php elseif($lang == 'ta'): ?>
                            பாலினம்
                        <?php else: ?>
                            Gender
                        <?php endif; ?>
                        <span class="text-red-500">*</span>
                    </label>
                    <select name="gender" id="gender" class="input-field">
                        <option value="">
                            <?php if($lang == 'si'): ?>
                                තෝරන්න
                            <?php elseif($lang == 'ta'): ?>
                                தேர்வு செய்யவும்
                            <?php else: ?>
                                Select
                            <?php endif; ?>
                        </option>
                        <option value="male" <?php echo e(old('gender') == 'male' ? 'selected' : ''); ?>>
                            <?php if($lang == 'si'): ?>
                                පුරුෂ
                            <?php elseif($lang == 'ta'): ?>
                                ஆண்
                            <?php else: ?>
                                Male
                            <?php endif; ?>
                        </option>
                        <option value="female" <?php echo e(old('gender') == 'female' ? 'selected' : ''); ?>>
                            <?php if($lang == 'si'): ?>
                                ස්ත්‍රී
                            <?php elseif($lang == 'ta'): ?>
                                பெண்
                            <?php else: ?>
                                Female
                            <?php endif; ?>
                        </option>
                    </select>
                    <?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-sm text-red-500 mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700" for="email">
                        <?php if($lang == 'si'): ?>
                            ඊ-මේල්
                        <?php elseif($lang == 'ta'): ?>
                            மின்னஞ்சல்
                        <?php else: ?>
                            Email
                        <?php endif; ?>
                    </label>
                    <input type="email" name="email" id="email" class="input-field"
                        placeholder="<?php if($lang == 'si'): ?> ඔබගේ ඊ-මේල් ලිපිනය ඇතුලත් කරන්න <?php elseif($lang == 'ta'): ?> மின்னஞ்சல் முகவரியை உள்ளிடவும் <?php else: ?> Enter Your Email <?php endif; ?>"
                        value="<?php echo e(old('email')); ?>">
                    <p class="mt-1 text-xs text-gray-500">
                        <?php if($lang == 'si'): ?>
                            ඊ-මේල් ලිපිනය විකල්ප වේ.
                        <?php elseif($lang == 'ta'): ?>
                            மின்னஞ்சல் முகவரி விருப்பமானது.
                        <?php else: ?>
                            Email address is optional.
                        <?php endif; ?>
                    </p>
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-sm text-red-500 mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700" for="name">
                        <?php if($lang == 'si'): ?>
                            සහභාගී වන්නන් සංඛ්‍යාව
                        <?php elseif($lang == 'ta'): ?>
                            பங்கேற்பாளர்களின் எண்ணிக்கை
                        <?php else: ?>
                            Number Of Attendees
                        <?php endif; ?>
                    </label>
                    <input type="number" name="attendees" id="attendees" class="input-field"
                        value="<?php echo e(old('attendees')); ?>"
                        placeholder="<?php if($lang == 'si'): ?> සහභාගී වන්නන් සංඛ්‍යාව ඇතුළත් කරන්න <?php elseif($lang == 'ta'): ?>
பங்கேற்பாளர்களின் எண்ணிக்கையை உள்ளிடவும். <?php else: ?> Enter Number Of Attendees <?php endif; ?>">
                    <?php $__errorArgs = ['attendees'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-sm text-red-500 mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <button type="submit" class="btn-register">
                    <?php if($lang == 'si'): ?>
                        ලියාපදිංචි වන්න
                    <?php elseif($lang == 'ta'): ?>
                        பதிவு செய்யவும்
                    <?php else: ?>
                        Register
                    <?php endif; ?>
                </button>
            </div>
        </form>
    </div>
</body>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<?php if(session('success')): ?>
    <script>
        Swal.fire({
            title: <?php if($lang == 'si'): ?>
                "සාර්ථකයි!"
            <?php elseif($lang == 'ta'): ?>
                "வெற்றிகரமாக பதிவு செய்யப்பட்டது!"
            <?php else: ?>
                "Success!"
            <?php endif; ?> ,
            text: <?php if($lang == 'si'): ?>
                "ඔබ සාර්ථකව ලියාපදිංචි විය!"
            <?php elseif($lang == 'ta'): ?>
                "நீங்கள் வெற்றிகரமாக பதிவு செய்துள்ளீர்கள்!"
            <?php else: ?>
                "You registered successfully!"
            <?php endif; ?> ,
            icon: "success"
        });
    </script>
<?php endif; ?>

<?php if($errors->any()): ?>
    <script>
        Swal.fire({
            title: <?php if($lang == 'si'): ?>
                "දෝෂයකි!"
            <?php elseif($lang == 'ta'): ?>
                "பிழை!"
            <?php else: ?>
                "Error!"
            <?php endif; ?> ,
            text: <?php if($lang == 'si'): ?>
                "කරුණාකර ඇතුලත් කිරිම් පරික්ෂාකර නැවත උත්සහ කරන්න."
            <?php elseif($lang == 'ta'): ?>
                "தயவுசெய்து உள்ளீடுகளை சரிபார்த்து மீண்டும் முயற்சிக்கவும்."
            <?php else: ?>
                "Please check your inputs and try again."
            <?php endif; ?> ,
            icon: "error"
        });
    </script>
<?php endif; ?>

<script>
    const form = document.querySelector('form');
    const loader = document.getElementById('loader');
    const submitButton = document.querySelector('.btn-register');

    form.addEventListener('submit', function(e) {
        loader.classList.remove('hidden');
        submitButton.disabled = true;
        submitButton.innerText =
            <?php if($lang == 'si'): ?>
                'ලියාපදිංචි වෙමින්...';
            <?php elseif($lang == 'ta'): ?>
                'பதிவு செய்யப்படுகிறது...';
            <?php else: ?>
                'Submitting...';
            <?php endif; ?>
    });

    // Reset loader and button on validation error
    window.addEventListener('load', function() {
        if (<?php echo e($errors->any() ? 'true' : 'false'); ?>) {
            loader.classList.add('hidden');
            submitButton.disabled = false;
            submitButton.innerText =
                <?php if($lang == 'si'): ?>
                    'ලියාපදිංචි වන්න';
                <?php elseif($lang == 'ta'): ?>
                    'பதிவு செய்யவும்';
                <?php else: ?>
                    'Register';
                <?php endif; ?>
        }
    });
</script>

</html>
<?php /**PATH /home/european/sltmobitelactivation.com/resources/views/welcome.blade.php ENDPATH**/ ?>